<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/BuonoSconto.php";
    
    if(isset($_GET["id"])) {
        $buono = new BuonoSconto($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $buono->caricaDatiDalDatabase();
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Componente e-commerce - Creazione buono sconto</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formProdotto" action="../../../controller/ecommerce/controllerBuoniSconto.php" method="post">
                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($buono) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo(isset($buono) ? $buono->getId() : "0"); ?>">
                    
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Buono sconto creato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==220) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Buono sconto modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-12 ">
                            <div class="form-row mb-3">
                                <div class="col-md-7 d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="home.php">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">E-commerce</a></li>
                                            <li class="breadcrumb-item"><a href="index.php?status==101">Buoni sconto</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($buono)? $buono->getNome() : "Nuovo buono sconto"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a class="btn btn-primary mr-1" href="creaBuonoSconto.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                    <a class="btn btn-outline-primary" href="index.php?status==101"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Nome</label>
                                            <input  type="text" class="form-control" name="nome" value="<?php echo((isset($buono)? $buono->getNome() : ""))?>" placeholder="Nome" required >
                                        </div>
                                    
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Codice sconto</label>
                                            <input  type="text" class="form-control" name="codice" value="<?php echo((isset($buono)? $buono->getCodice() : ""))?>" placeholder="Codice" required >
                                            <small class="text-muted">Il codice di sconto che può essere inserito in fase di finalizzazione dell'ordine</small>
                                        </div>
                                        
                                        <?php
                                            $tipiBuono = array("percentuale di sconto","sconto in euro");
                                        ?>
                                        <div class="form-group col-md-3">
                                            <label for="select1" class="sottotitolo-articolo">Tipo sconto</label>
                                            <select class="selectpicker w-100" name="tipo">
                                                <?php
                                                    foreach($tipiBuono as $tipo) {
                                                        if(isset($buono) && $buono->getTipo() == $tipo) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"$tipo\" $selezionato >{$tipo}</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Ammontare</label>
                                            <input  type="number" step="0.01" class="form-control" name="ammontare" value="<?php echo((isset($buono)? $buono->getAmmontare() : "0"))?>" placeholder="Ammontare">
                                            <small class="text-muted"> Inserisci l'ammontare dello sconto</small>
                                        </div>
                                        
                                        <hr class="w-100">
                                        
                                        <div class="col-12">
                                            <h5>Regole</h5>
                                        </div>
                                        
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Data scadenza</label>
                                            <input  type="date" class="form-control" name="dataScadenza" value="<?php echo((isset($buono)? $buono->getDataScadenza() : date("Y-m-d")))?>" placeholder="Nome">
                                        </div>
                                        
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Buoni disponibili</label>
                                            <input  type="number" class="form-control" name="buoniRimanenti" value="<?php echo((isset($buono)? $buono->getBuoniRimanenti() : "0"))?>" placeholder="Numero coupon">
                                            <small class="text-muted"> Numero di buoni sconto disponibili</small>
                                        </div>
                                        
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Spesa minima €</label>
                                            <input  type="number" step="0.01" class="form-control" name="spesaMinima" value="<?php echo((isset($buono)? $buono->getSpesaMinima() : "1"))?>" placeholder="Spesa minima">
                                            <small class="text-muted"> Importo minimo a partire dal quale lo sconto è applicabile</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Limite di utilizzo per singolo utente</label>
                                            <input  type="number" class="form-control" name="limitePerPersona" value="<?php echo((isset($buono)? $buono->getLimitePerPersona() : "1"))?>" placeholder="Limite di utilizzo per singolo utente">
                                            <small class="text-muted"> Numero massimo di volte che un singolo utente può usare questo buono sconto</small>
                                        </div>
                                        
                                        <?php
                                            $prodottiDestinatari = array("Tutti i prodotti","Categoria di prodotti","Singolo prodotto");
                                        ?>
                                        <div class="form-group col-md-3">
                                            <label for="select1" class="sottotitolo-articolo">Prodotti</label>
                                            <select class="selectpicker w-100" id="prodottiInteressati" name="prodottiInteressati" onchange="mostraCampiCondizionali()">
                                                <?php
                                                    foreach($prodottiDestinatari as $prodottoDestinatario) {
                                                        if(isset($buono) && $buono->getProdottiInteressati() == $prodottoDestinatario) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"$prodottoDestinatario\" $selezionato >{$prodottoDestinatario}</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="<?php echo((isset($buono) && $buono->getProdottiInteressati()=="Categoria di prodotti") ? "form-group col-md-3" : "d-none") ?>" id="divSelezionaCategoria">
                                            <label for="select1" class="sottotitolo-articolo">Categoria</label>
                                            <select class="selectpicker w-100" name="categoria">
                                                <option value="0">Seleziona</option>
                                                <?php
                                                    $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($buono) && $buono->getId()!=0 && $buono->getCategoria() == $categoria["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";

                                                        $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                        $risSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                        while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                            if(isset($buono) && $buono->getId()!=0 && $buono->getCategoria() == $sottoCategoria["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }

                                                            echo"<option value=\"{$sottoCategoria["id"]}\" $selezionato > - {$sottoCategoria["nome"]}</option>";

                                                            $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                            $risSottoSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                            while($sottoSottoCategoria = $risSottoSottoCategorie->fetch_assoc()) {
                                                                if(isset($buono) && $buono->getId()!=0 && $buono->getCategoria() == $sottoSottoCategoria["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }

                                                                echo"<option value=\"{$sottoSottoCategoria["id"]}\" $selezionato > -- {$sottoSottoCategoria["nome"]}</option>";
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="<?php echo((isset($buono) && $buono->getProdottiInteressati()=="Singolo prodotto") ? "form-group col-md-3" : "d-none") ?>" id="divSelezionaProdotto">
                                            <label for="select1" class="sottotitolo-articolo">Singolo prodotto</label>
                                            <select class="selectpicker w-100" name="singoloProdotto">
                                                <option value="0">Seleziona</option>
                                                <?php
                                                    $queryNomiTag = "SELECT * FROM geecEc_prodotti";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($buono) && $buono->getProdotto() == $categoria["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                            
                            </form>

                        </div>
                        <!-- Colonna principale -->
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
        ?>
            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>
        
        <script>
            
            function mostraCampiCondizionali() {
                document.getElementById("divSelezionaCategoria").className = "d-none";
                document.getElementById("divSelezionaProdotto").className  = "d-none";
                var prodottiInteressati = document.getElementById("prodottiInteressati").value;
                
                if(prodottiInteressati=="Categoria di prodotti") {
                    document.getElementById("divSelezionaCategoria").className = "form-group col-md-3";
                }
                else if(prodottiInteressati=="Singolo prodotto"){
                    document.getElementById("divSelezionaProdotto").className = "form-group col-md-3";
                }
            }
        </script>
    </body>
</html>
